function ImportPath(bookguid, folderpath, objCABookBuilder, objShell, objFileSystem, path)
{
    var objFolder = objFileSystem.GetFolder(path);
    //
    var objSubfilesEnum = new Enumerator(objFolder.Files);
    for (; !objSubfilesEnum.atEnd(); objSubfilesEnum.moveNext())
    {
        var filename = objSubfilesEnum.item();
        var objFile = objFileSystem.GetFile(filename);
        //
        var strFileTitle = objFile.Name;
        var pos = strFileTitle.indexOf(".url");
        if (-1 != pos)
        {
            strFileTitle = strFileTitle.substring(0, pos);
            //objShell.Popup("file name is: " + filename);
            //
            try
            {
                var objShortcut = objShell.CreateShortcut(filename);
                //
                //objShell.Popup(objShortcut.TargetPath);
                var url = objShortcut.TargetPath;
                //
                objCABookBuilder.AddJob(bookguid, folderpath, url, strFileTitle, "Default", 0, true, true, 0);
            }
            catch (e)
            {
            }
        }
    }
    //
    var objSubfoldersEnum = new Enumerator(objFolder.SubFolders);
    for (; !objSubfoldersEnum.atEnd(); objSubfoldersEnum.moveNext())
    {
        var subfolder = objSubfoldersEnum.item();
        //
        var objSubFolder = objFileSystem.GetFolder(subfolder);
        var subfoldername = objSubFolder.Name;
        //
        ImportPath(bookguid, folderpath + "\\" + subfoldername, objCABookBuilder, objShell, objFileSystem, subfolder);
    }
}


var objCA = new ActiveXObject("CyberArticle.CAAutomationApp");
//
var objSelectedNodes = objCA.SelectedNodes;
if (objSelectedNodes != null && objSelectedNodes.Count > 0)
{
    var objShell = new ActiveXObject("WScript.Shell");
    //
    var objSelectedNode = objSelectedNodes.Item(0);
    if (objSelectedNode.Type != 0)
        objSelectedNode = objSelectedNode.ParentNode;
    //
    var strBookGUID = objSelectedNode.Book.GUID;
    var folderpath = objSelectedNode.GetTitlePath(true, false);
    //objShell.Popup("title path: " + folderpath);
    //
    var objCABookBuilder = new ActiveXObject("CyberArticle.CABookBuilderAutomationApp");

    var strPath = objShell.SpecialFolders("Favorites");
    strPath = objShell.ExpandEnvironmentStrings(strPath);
    //objShell.Popup(strPath);

    var objFileSystem = new ActiveXObject("Scripting.FileSystemObject");
    
    ImportPath(strBookGUID, folderpath, objCABookBuilder, objShell, objFileSystem, strPath);
    //
    objCABookBuilder.StartDownload();
}
